/////////////////////////////////////////////////////////////////////////////
// Logox4 SDK - Header File
// (C) Copyright G DATA Software AG 1992-2001
//
/////////////////////////////////////////////////////////////////////////////
//
//	(4.0.0.0)	05/07/01	creation
//				17/07/01	interface definition fixed
//				25/07/01	approved
//				03/08/01	compatible to std c
//				27/11/01	added LogoxSkip
//
/////////////////////////////////////////////////////////////////////////////

#ifndef __LGX4_H_INCLUDED__
#define __LGX4_H_INCLUDED__

/////////////////////////////////////////////////////////////////////////////
// Logox4 library functions
/////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif

UINT WINAPI LogoxDLLVersion();
UINT WINAPI LogoxServerVersion();
BOOL WINAPI LogoxLicenseA(PCSTR szLicense);
BOOL WINAPI LogoxLicenseW(PCWSTR szLicense);
BOOL WINAPI LogoxInitialize();
BOOL WINAPI LogoxIsConnected();
void WINAPI LogoxRelease();
BOOL WINAPI LogoxBroadcast(UINT nMsg,WPARAM wParam);
UINT WINAPI LogoxCode(UINT nID,UINT nCode);

BOOL WINAPI LogoxSpeakA(PCSTR szText,UINT nActionID);
BOOL WINAPI LogoxSpeakW(PCWSTR szText,UINT nActionID);
BOOL WINAPI LogoxPause();
BOOL WINAPI LogoxResume();
BOOL WINAPI LogoxStop();
BOOL WINAPI LogoxSkip();
BOOL WINAPI LogoxRecordA(PCSTR szFile,PCSTR szText,UINT nActionID);
BOOL WINAPI LogoxRecordW(PCWSTR szFile,PCWSTR szText,UINT nActionID);
BOOL WINAPI LogoxIsBusy();
BOOL WINAPI LogoxIsPaused();

UINT WINAPI LogoxGetNumberOfFonts();
UINT WINAPI LogoxFindFontAliasA(PCSTR szAlias);
UINT WINAPI LogoxFindFontAliasW(PCWSTR szAlias);
UINT WINAPI LogoxGetFontNameA(UINT nIndex,PSTR szName,UINT nBytes);
UINT WINAPI LogoxGetFontNameW(UINT nIndex,PWSTR szName,UINT nBytes);
UINT WINAPI LogoxGetFontAliasA(UINT nIndex,PSTR szName,UINT nBytes);
UINT WINAPI LogoxGetFontAliasW(UINT nIndex,PWSTR szName,UINT nBytes);
UINT WINAPI LogoxGetFontUUID(UINT nIndex,unsigned char* pUUID,UINT nBytes);
UINT WINAPI LogoxGetFontDate(UINT nIndex);
UINT WINAPI LogoxGetFontVersion(UINT nIndex);
UINT WINAPI LogoxGetFontFlags(UINT nIndex);

BOOL WINAPI LogoxLoadSettingsA(PCSTR szApplicationName);
BOOL WINAPI LogoxLoadSettingsW(PCWSTR szApplicationName);
BOOL WINAPI LogoxSaveSettingsA(PCSTR szApplicationName);
BOOL WINAPI LogoxSaveSettingsW(PCWSTR szApplicationName);
BOOL WINAPI LogoxResetLocal();
BOOL WINAPI LogoxResetGlobal();
BOOL WINAPI LogoxSetAudioFormat(UINT nAudioFormat);
UINT WINAPI LogoxGetAudioFormat();
BOOL WINAPI LogoxSetLocalFont(UINT nFont);
UINT WINAPI LogoxGetLocalFont();
BOOL WINAPI LogoxSetGlobalFont(UINT nFont);
UINT WINAPI LogoxGetGlobalFont();
BOOL WINAPI LogoxSetLocalVolume(long nVolume);
long WINAPI LogoxGetLocalVolume();
BOOL WINAPI LogoxSetGlobalVolume(long nVolume);
long WINAPI LogoxGetGlobalVolume();
BOOL WINAPI LogoxSetLocalPitch(long nPitch);
long WINAPI LogoxGetLocalPitch();
BOOL WINAPI LogoxSetGlobalPitch(long nPitch);
long WINAPI LogoxGetGlobalPitch();
BOOL WINAPI LogoxSetLocalSpeed(long nSpeed);
long WINAPI LogoxGetLocalSpeed();
BOOL WINAPI LogoxSetGlobalSpeed(long nSpeed);
long WINAPI LogoxGetGlobalSpeed();
BOOL WINAPI LogoxSetLocalIntonation(long nIntonation);
long WINAPI LogoxGetLocalIntonation();
BOOL WINAPI LogoxSetGlobalIntonation(long nIntonation);
long WINAPI LogoxGetGlobalIntonation();
BOOL WINAPI LogoxSetLocalRoughness(long nRoughness);
long WINAPI LogoxGetLocalRoughness();
BOOL WINAPI LogoxSetGlobalRoughness(long nRoughness);
long WINAPI LogoxGetGlobalRoughness();

BOOL WINAPI LogoxNotifyModeLocal();
BOOL WINAPI LogoxNotifyModeGlobal();
BOOL WINAPI LogoxNotifyAction(HWND hWnd,UINT nMsg,HANDLE hEvent);
BOOL WINAPI LogoxNotifyMark(HWND hWnd,UINT nMsg,HANDLE hEvent);
BOOL WINAPI LogoxNotifyChunk(HWND hWnd,UINT nMsg,HANDLE hEvent);
BOOL WINAPI LogoxNotifyParam(HWND hWnd,UINT nMsg,HANDLE hEvent);
BOOL WINAPI LogoxNotifySentence(HWND hWnd,UINT nMsg,HANDLE hEvent);
BOOL WINAPI LogoxNotifyWord(HWND hWnd,UINT nMsg,HANDLE hEvent);
BOOL WINAPI LogoxNotifyMouth(HWND hWnd,UINT nMsg,HANDLE hEvent);
BOOL WINAPI LogoxNotifyViseme(HWND hWnd,UINT nMsg,HANDLE hEvent);
BOOL WINAPI LogoxNotifyBroadcast(HWND hWnd);

#ifdef __cplusplus
}
#endif

/////////////////////////////////////////////////////////////////////////////
// unicode vs multibyte
/////////////////////////////////////////////////////////////////////////////

#ifdef UNICODE
#define LogoxLicense			LogoxLicenseW
#define LogoxLoadSettings		LogoxLoadSettingsW
#define LogoxSaveSettings		LogoxSaveSettingsW
#define LogoxSpeak				LogoxSpeakW
#define LogoxRecord				LogoxRecordW
#define LogoxGetFontName		LogoxGetFontNameW
#define LogoxGetFontAlias		LogoxGetFontAliasW
#define LogoxFindFontAlias		LogoxFindAliasW
#else
#define LogoxLicense			LogoxLicenseA
#define LogoxLoadSettings		LogoxLoadSettingsA
#define LogoxSaveSettings		LogoxSaveSettingsA
#define LogoxSpeak				LogoxSpeakA
#define LogoxRecord				LogoxRecordA
#define LogoxGetFontName		LogoxGetFontNameA
#define LogoxGetFontAlias		LogoxGetFontAliasA
#define LogoxFindFontAlias		LogoxFindFontAliasA
#endif

/////////////////////////////////////////////////////////////////////////////
// local function are defaults
/////////////////////////////////////////////////////////////////////////////

#define LogoxSetFont			LogoxSetLocalFont
#define LogoxGetFont			LogoxGetLocalFont
#define LogoxSetVolume			LogoxSetLocalVolume
#define LogoxGetVolume			LogoxGetLocalVolume
#define LogoxSetPitch			LogoxSetLocalPitch
#define LogoxGetPitch			LogoxGetLocalPitch
#define LogoxSetSpeed			LogoxSetLocalSpeed
#define LogoxGetSpeed			LogoxGetLocalSpeed
#define LogoxSetIntonation		LogoxSetLocalIntonation
#define LogoxGetIntonation		LogoxGetLocalIntonation
#define LogoxSetRoughness		LogoxSetLocalRoughness
#define LogoxGetRoughness		LogoxGetLocalRoughness

/////////////////////////////////////////////////////////////////////////////
// some defines for audio formats
/////////////////////////////////////////////////////////////////////////////

#define LOGOX_AUDIOFORMAT(r,b,c)	(((r)<<8)|((b)<<2)|(c))
#define LOGOX_AUDIORATE(fmt)		(((fmt)>>8)&0x00FFFFFF)
#define LOGOX_AUDIOBITS(fmt)		(((fmt)>>2)&0x0000003F)
#define LOGOX_AUDIOCHANNEL(fmt)		((fmt)&0x00000003)

#define LOGOX_8kHz8BitMono		LOGOX_AUDIOFORMAT(8000,8,1)
#define LOGOX_8kHz8BitStereo	LOGOX_AUDIOFORMAT(8000,8,2)
#define LOGOX_8kHz16BitMono		LOGOX_AUDIOFORMAT(8000,16,1)
#define LOGOX_8kHz16BitStereo	LOGOX_AUDIOFORMAT(8000,16,2)
#define LOGOX_11kHz8BitMono		LOGOX_AUDIOFORMAT(11025,8,1)
#define LOGOX_11kHz8BitStereo	LOGOX_AUDIOFORMAT(11025,8,2)
#define LOGOX_11kHz16BitMono	LOGOX_AUDIOFORMAT(11025,16,1)
#define LOGOX_11kHz16BitStereo	LOGOX_AUDIOFORMAT(11025,16,2)
#define LOGOX_12kHz8BitMono		LOGOX_AUDIOFORMAT(12000,8,1)
#define LOGOX_12kHz8BitStereo	LOGOX_AUDIOFORMAT(12000,8,2)
#define LOGOX_12kHz16BitMono	LOGOX_AUDIOFORMAT(12000,16,1)
#define LOGOX_12kHz16BitStereo	LOGOX_AUDIOFORMAT(12000,16,2)
#define LOGOX_16kHz8BitMono		LOGOX_AUDIOFORMAT(16000,8,1)
#define LOGOX_16kHz8BitStereo	LOGOX_AUDIOFORMAT(16000,8,2)
#define LOGOX_16kHz16BitMono	LOGOX_AUDIOFORMAT(16000,16,1)
#define LOGOX_16kHz16BitStereo	LOGOX_AUDIOFORMAT(16000,16,2)
#define LOGOX_22kHz8BitMono		LOGOX_AUDIOFORMAT(22050,8,1)
#define LOGOX_22kHz8BitStereo	LOGOX_AUDIOFORMAT(22050,8,2)
#define LOGOX_22kHz16BitMono	LOGOX_AUDIOFORMAT(22050,16,1)
#define LOGOX_22kHz16BitStereo	LOGOX_AUDIOFORMAT(22050,16,2)
#define LOGOX_24kHz8BitMono		LOGOX_AUDIOFORMAT(24000,8,1)
#define LOGOX_24kHz8BitStereo	LOGOX_AUDIOFORMAT(24000,8,2)
#define LOGOX_24kHz16BitMono	LOGOX_AUDIOFORMAT(24000,16,1)
#define LOGOX_24kHz16BitStereo	LOGOX_AUDIOFORMAT(24000,16,2)
#define LOGOX_32kHz8BitMono		LOGOX_AUDIOFORMAT(32000,8,1)
#define LOGOX_32kHz8BitStereo	LOGOX_AUDIOFORMAT(32000,8,2)
#define LOGOX_32kHz16BitMono	LOGOX_AUDIOFORMAT(32000,16,1)
#define LOGOX_32kHz16BitStereo	LOGOX_AUDIOFORMAT(32000,16,2)
#define LOGOX_44kHz8BitMono		LOGOX_AUDIOFORMAT(44100,8,1)
#define LOGOX_44kHz8BitStereo	LOGOX_AUDIOFORMAT(44100,8,2)
#define LOGOX_44kHz16BitMono	LOGOX_AUDIOFORMAT(44100,16,1)
#define LOGOX_44kHz16BitStereo	LOGOX_AUDIOFORMAT(44100,16,2)
#define LOGOX_48kHz8BitMono		LOGOX_AUDIOFORMAT(48000,8,1)
#define LOGOX_48kHz8BitStereo	LOGOX_AUDIOFORMAT(48000,8,2)
#define LOGOX_48kHz16BitMono	LOGOX_AUDIOFORMAT(48000,16,1)
#define LOGOX_48kHz16BitStereo	LOGOX_AUDIOFORMAT(48000,16,2)

#define LOGOX_DEFAULT_AUDIO		LOGOX_44kHz16BitMono

/////////////////////////////////////////////////////////////////////////////
// byte access in DWORDs
/////////////////////////////////////////////////////////////////////////////

#define LOGOX_LONGBYTE3(v)		((unsigned char)((v)>>24))
#define LOGOX_LONGBYTE2(v)		((unsigned char)((v)>>16))
#define LOGOX_LONGBYTE1(v)		((unsigned char)((v)>>8))
#define LOGOX_LONGBYTE0(v)		((unsigned char)(v))

/////////////////////////////////////////////////////////////////////////////
// date access
/////////////////////////////////////////////////////////////////////////////

#define LOGOX_DATEYEAR(v)		(((v)/(13*32*24*60))%7000)
#define LOGOX_DATEMONTH(v)		(((v)/(32*24*60))%13)
#define LOGOX_DATEDAY(v)		(((v)/(24*60))%32)
#define LOGOX_DATEHOUR(v)		(((v)/60)%24)
#define LOGOX_DATEMIN(v)		((v)%60)


#endif	// __LGX4_H_INCLUDED__
